Ext.define('Photoalbum.view.DetailComments', {
	extend: 'Ext.Panel',
	xtype: 'photoalbum-detail-comments',
	id: 'detailcomments',
	initialized: false,

    config : {
    	title: 'Kommentare',
    	scrollable: true,
    	items: []
    },
    
    bindComments: function(comments) {
    	this.add(
   			{
     			xtype: 'list',
       			id: 'commentlist',
       			itemTpl: '<div><b>{author}:</b><p>{content}</p></div>',
       			scrollable: false,
       			store: Ext.create('Ext.data.ArrayStore', {
       				fields: ['author','content'],
       				data: comments
       			})    
       		},
   			{
       			xtype: 'fieldset',
       			layout: 'hbox',
       			items: [{
	       			xtype: 'textareafield',
	       			id: 'newcomment',
	       			flex: 12
       			},{
	       			xtype: 'button',
	       			id: 'addcomment',
	       			flex: 1,
	       			iconMask: true,
	       			iconCls: 'add'
       			}]
       		}
    	);
    }
});